<?php

declare(strict_types=1);

namespace Drupal\image_styles_mapping\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Url;

/**
 * Hook help.
 */
class Help {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function helpHook(string $route_name, RouteMatchInterface $route_match): ?string {
    switch ($route_name) {
      case 'help.page.image_styles_mapping':
        $output = '<p>' . $this->t('This module allows you to have a report listing the image styles per image fields and per view modes on all entities.') . '</p>';
        $output .= '<p>' . $this->t('The report can be accessed <a href=":url">here</a>.', [':url' => Url::fromRoute('image_styles_mapping.report')->toString()]) . '</p>';
        return $output;
    }
    return NULL;
  }

}
