<?php

declare(strict_types=1);

namespace Drupal\image_styles_mapping\Plugin;

use Drupal\Component\Render\FormattableMarkup;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\Core\Render\RendererInterface;

/**
 * Base class for plugins able to add columns on image styles mapping reports.
 *
 * @ingroup plugin_api
 */
abstract class ImageStylesMappingPluginBase extends PluginBase implements ContainerFactoryPluginInterface, ImageStylesMappingPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    array $plugin_definition,
    protected EntityTypeManagerInterface $entityTypeManager,
    protected RendererInterface $renderer,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public function getDependencies(): array {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public function getHeader() {
    return '';
  }

  /**
   * {@inheritdoc}
   */
  public function getRowData(array $field_settings) {
    return new FormattableMarkup('', []);
  }

  /**
   * {@inheritdoc}
   */
  public function calculateDependencies(): array {
    return [];
  }

  /**
   * Helper function.
   *
   * Checks if a value is used in an array.
   *
   * @param string $needle
   *   The value searched.
   * @param array $haystack
   *   The array in which the value is searched.
   * @param bool $result
   *   If the needle has been found.
   */
  protected function recursiveSearch($needle, array $haystack, &$result): void {
    foreach ($haystack as $value) {
      if (\is_array($value)) {
        $this->recursiveSearch($needle, $value, $result);
      }
      elseif ($needle === $value) {
        $result = TRUE;
      }
    }
  }

}
