<?php

declare(strict_types=1);

namespace Drupal\image_to_media_swapper;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Defines the access control handler for the media swap record entity type.
 */
final class MediaSwapRecordAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    switch ($operation) {
      case 'view':
        return AccessResult::allowedIfHasPermission($account, 'view media swap records');

      case 'update':
        return AccessResult::allowedIfHasPermissions($account, [
          'edit media swap records',
          'administer image to media swapper',
        ], 'OR');

      case 'delete':
        return AccessResult::allowedIfHasPermissions($account, [
          'delete media swap records',
          'administer image to media swapper',
        ], 'OR');

      default:
        return AccessResult::neutral();
    }
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermissions($account, [
      'create media swap records',
      'administer image to media swapper',
    ], 'OR');
  }

}
