<?php

declare(strict_types=1);

namespace Drupal\image_to_media_swapper;

use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Entity\EntityStorageInterface;
use Drupal\Core\Entity\EntityTypeInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Defines a class to build a listing of media swap record entities.
 *
 * @see \Drupal\image_to_media_swapper\Entity\MediaSwapRecord
 */
final class MediaSwapRecordListBuilder extends EntityListBuilder {

  public function __construct(
    EntityTypeInterface $entity_type,
    EntityStorageInterface $entity_type_manager,
    private readonly MediaSwapRecordTableService $tableService,
  ) {
    parent::__construct($entity_type, $entity_type_manager);
  }

  /**
   * {@inheritdoc}
   */
  public static function createInstance(ContainerInterface $container, EntityTypeInterface $entity_type): MediaSwapRecordListBuilder {
    /** @var \Drupal\image_to_media_swapper\MediaSwapRecordTableService $tableService */
    $tableService = $container->get('image_to_media_swapper.table_service');
    return new MediaSwapRecordListBuilder(
      $entity_type,
      $container->get('entity_type.manager')->getStorage($entity_type->id()),
      $tableService,
    );
  }

  /**
   * {@inheritdoc}
   */
  public function render(): array {
    return $this->tableService->buildTable();
  }

}
