import js from '@eslint/js';
import globals from 'globals';

export default [
  {
    ignores: ['js/build/**', 'node_modules/**', 'css/**']
  },
  js.configs.recommended,
  {
    files: ['**/*.{js,mjs,cjs}'],
    languageOptions: {
      globals: {
        ...globals.browser,
        Drupal: 'readonly',
        drupalSettings: 'readonly',
        jQuery: 'readonly',
        $: 'readonly',
        _: 'readonly',
        Modernizr: 'readonly',
        Popper: 'readonly',
        Sortable: 'readonly',
        Backbone: 'readonly',
        Dropzone: 'readonly',
        CKEditor: 'readonly',
        CKEDITOR: 'readonly',
        domready: 'readonly'
      },
      ecmaVersion: 2018,
      sourceType: 'script'
    },
    rules: {
      // Drupal coding standards
      'array-bracket-spacing': ['error', 'never'],
      'block-scoped-var': 'error',
      'brace-style': ['error', 'stroustrup', {allowSingleLine: true}],
      'comma-dangle': ['error', 'never'],
      'comma-spacing': 'error',
      'comma-style': ['error', 'last'],
      'computed-property-spacing': ['error', 'never'],
      'curly': ['error', 'all'],
      'eol-last': 'error',
      'func-call-spacing': ['error', 'never'],
      'indent': ['error', 2, {SwitchCase: 1}],
      'key-spacing': ['error', {beforeColon: false, afterColon: true}],
      'keyword-spacing': 'error',
      'line-comment-position': ['error', {position: 'above'}],
      'linebreak-style': ['error', 'unix'],
      'max-nested-callbacks': ['error', 3],
      'new-parens': 'error',
      'no-array-constructor': 'error',
      'no-caller': 'error',
      'no-catch-shadow': 'off',
      'no-eval': 'error',
      'no-extend-native': 'error',
      'no-extra-bind': 'error',
      'no-extra-parens': ['error', 'functions'],
      'no-implied-eval': 'error',
      'no-iterator': 'error',
      'no-label-var': 'error',
      'no-labels': 'error',
      'no-lone-blocks': 'error',
      'no-loop-func': 'error',
      'no-multi-spaces': 'error',
      'no-multi-str': 'error',
      'no-native-reassign': 'error',
      'no-nested-ternary': 'error',
      'no-new-func': 'error',
      'no-new-object': 'error',
      'no-new-wrappers': 'error',
      'no-octal-escape': 'error',
      'no-process-exit': 'error',
      'no-proto': 'error',
      'no-return-assign': 'error',
      'no-script-url': 'error',
      'no-sequences': 'error',
      'no-shadow-restricted-names': 'error',
      'no-spaced-func': 'error',
      'no-trailing-spaces': 'error',
      'no-undef-init': 'error',
      'no-undefined': 'error',
      'no-unused-expressions': 'error',
      'no-unused-vars': ['error', {vars: 'all', args: 'none'}],
      'no-with': 'error',
      'object-curly-spacing': ['error', 'never'],
      'one-var': ['error', 'never'],
      'quote-props': ['error', 'consistent-as-needed'],
      'quotes': ['error', 'single', 'avoid-escape'],
      'semi': ['error', 'always'],
      'semi-spacing': ['error', {before: false, after: true}],
      'space-before-blocks': ['error', 'always'],
      'space-before-function-paren': ['error', {anonymous: 'always', named: 'never'}],
      'space-in-parens': ['error', 'never'],
      'space-infix-ops': 'error',
      'space-unary-ops': ['error', {words: true, nonwords: false}],
      'spaced-comment': ['error', 'always'],
      'strict': ['error', 'function'],
      'yoda': ['error', 'never'],
      // Disable some rules that conflict with Drupal
      'no-var': 'off'
    }
  },
  {
    files: ['js/ckeditor5_plugins/**/*.js'],
    languageOptions: {
      globals: {
        ...globals.browser,
        CKEditor5: 'readonly'
      },
      ecmaVersion: 2018,
      sourceType: 'module'
    },
    rules: {
      'strict': 'off',
      'no-var': 'error'
    }
  },
  {
    files: ['webpack.config.js'],
    languageOptions: {
      globals: {
        ...globals.node
      },
      sourceType: 'script'
    },
    rules: {
      'no-var': 'off',
      'strict': 'off'
    }
  },
  {
    files: ['*.config.mjs'],
    languageOptions: {
      globals: {
        ...globals.node
      },
      sourceType: 'module'
    },
    rules: {
      'no-var': 'off',
      'strict': 'off'
    }
  }
];
