import {Plugin} from 'ckeditor5/src/core';
import {ButtonView} from 'ckeditor5/src/ui';

export default class LogSelectedElement extends Plugin {
  init() {
    const editor = this.editor;

    editor.ui.componentFactory.add('logSelected', locale => {
      const button = new ButtonView(locale);

      button.set({
        label: 'Log Selected',
        tooltip: true,
        withText: true
      });

      button.on('execute', () => {
        const selection = editor.model.document.selection;
        const selectedElement = selection.getSelectedElement();
        const position = selection.getFirstPosition();


        console.log('--- LOGGING SELECTION ---');

        console.log('Selected element:', selectedElement);

        console.log('First position parent:', position.parent.name);

        console.log('First position parent attrs:', position.parent.getAttributes());

        console.log('First position:', selection.getFirstPosition().parent.name);

        console.log('Last position:', selection.getLastPosition().parent.name);

        console.log('--------------------------');
      });

      return button;
    });
  }
}
