# Image to Media Swapper

## INTRODUCTION

Image to Media Swapper provides tools for converting embedded file-based images and file links into reusable media entities. This module helps migrate legacy content from direct file references to Drupal's structured media system while maintaining content integrity and reducing duplicate files.

The module adds both CKEditor 5 integration for converting images and links during content editing, and a batch processing tool for converting large volumes of existing content.

* For a full description of the module, visit the [project page](https://www.drupal.org/project/image_to_media_swapper).
* To submit bug reports and feature suggestions, or track changes, visit the [issue queue](https://www.drupal.org/project/issues/image_to_media_swapper).

## REQUIREMENTS

This module requires the following modules:
* [Media](https://www.drupal.org/docs/8/core/modules/media) (Core)
* [Image](https://www.drupal.org/docs/8/core/modules/image) (Core)
* [File](https://www.drupal.org/docs/8/core/modules/file) (Core)
* [CKEditor 5](https://www.drupal.org/docs/core-modules-and-themes/core-modules/ckeditor-5-module) (Core)

### Recommended modules
* [Linkit](https://www.drupal.org/project/linkit): Required for file link conversion functionality. Without Linkit, only image conversion will work.

## INSTALLATION

Install as you would normally install a contributed Drupal module.

* Using Composer (recommended):
```bash
composer require drupal/image_to_media_swapper
drush en image_to_media_swapper
```

* Manual installation:
  1. Download the module and place it in the `modules/contrib` directory
  2. Enable the module using Drush or the Extend page:
```bash
drush en image_to_media_swapper
```

Visit [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules) for further information.

## CONFIGURATION

### CKEditor 5 Integration

1. Go to **Administration > Configuration > Content authoring > Text formats and editors**
2. Edit a text format that uses CKEditor 5
3. In the toolbar configuration, drag the "Convert to Media" button to your desired position
4. Save the text format

Ensure your text format allows:
* `<img>` tags with `src`, `alt`, `width`, `height` attributes
* `<drupal-media>` tags with `data-entity-type`, `data-entity-uuid`, `data-view-mode` attributes

### Security Settings

To configure security settings for file handling:

1. Go to **Administration > Configuration > Content authoring > Image to Media Swapper > Security Settings**
2. Configure:
   * Remote file download settings
   * File size limits
   * Allowed domains and file types
   * IP restrictions and HTTPS requirements
   * Timeout and redirect settings

## USAGE

### Converting Images and File Links in CKEditor

1. **For Images**: Insert an image into CKEditor 5 content, select it, and click the "Convert to Media" button
2. **For File Links**: Create a link to a file (requires Linkit module), select the link, and click the "Convert to Media" button
3. Confirm the conversion in the dialog
4. Images are replaced with `<drupal-media>` elements, file links are converted to media-linked references

### Batch Processing

Access the batch conversion tool at: **Administration > Content > Image to Media Swapper**

1. **Select Fields**: Choose text fields containing `<img>` tags or file links to convert
2. **Process Images**: Converts embedded image tags to media entities
3. **Process File Links**: Converts file links to media-linked references (requires Linkit)
4. **Review Results**: View processing results and status for each converted entity

The batch processor can:
* Find all entities with embedded images or file links in specified text fields
* Convert both images and links in a single operation
* Handle local files, remote files (with security validation), and existing file entities
* Create appropriate media entities based on file types
* Track conversion results and errors

### Using the Media Swap Record Table

The module tracks all conversion operations. You can view and manage these records at:
**Administration > Content > Media Swap Records**

This table displays:
* Source content and field information
* Conversion timestamp and status
* Original file information and created media entity
* Conversion details and any error messages

## FEATURES

### CKEditor Integration
* Adds a "Convert to Media" button to CKEditor 5 toolbar
* Provides accessible confirmation dialog
* Handles both image and file link conversions
* Maintains alignment and presentation attributes

### File Handling
* Converts embedded file images (`<img>` tags) into media entities (`<drupal-media>` elements)
* Converts file links (`<a>` tags pointing to files) into media-linked references
* Prevents duplicate media creation by reusing existing entities
* Supports multiple file types with automatic media type detection
* Handles both local and remote files with proper security validation

### Batch Processing
* Provides entity-type and field-level selection for processing
* Supports processing large volumes of content through the batch API
* Allows selective processing of images, links, or both
* Creates detailed logs of all conversions

### Security Features
* Comprehensive file validation for type, size, and content
* Domain and IP restrictions for remote downloads
* HTTPS enforcement options
* Content verification to prevent malicious file uploads
* Path traversal protection
* File content verification

## TROUBLESHOOTING

* **Images not converting**: Ensure your text format allows both `<img>` tags and `<drupal-media>` elements
* **File links not working**: Verify that Linkit module is installed and configured
* **Batch processing errors**: Check the Media Swap Records table for detailed error messages
* **Media entities not displaying**: Ensure media view modes are configured correctly
* **Permission issues**: Verify that users have the "Use Image to Media Swapper" permission

For more detailed troubleshooting:
1. Check the Drupal watchdog logs for specific error messages
2. Enable Drupal's development settings to see full error details
3. Review the Media Swap Records table for specific conversion errors

## MAINTAINERS

Current maintainers:
- [Chris Dart](https://www.drupal.org/u/chris-dart)

## ADDITIONAL INFORMATION

### API Usage

The module provides several services that can be used programmatically:

```php
// Convert an image to a media entity
$swapperService = \Drupal::service('image_to_media_swapper.service');
$media = $swapperService->validateAndProcessFilePath('/sites/default/files/my-image.jpg');

// Process content with batch operations
$batchProcessor = \Drupal::service('image_to_media_swapper.batch_processor_service');
$result = $batchProcessor->processContentByCategory('node.article.body', [$node], 'images');
```

### Contributing

Contributions are welcome! Please follow these steps:
1. Review the [issue queue](https://www.drupal.org/project/issues/image_to_media_swapper)
2. Create a new issue or pick an existing one
3. Submit a patch following [Drupal coding standards](https://www.drupal.org/docs/develop/standards)

### Related Modules

* [Entity Embed](https://www.drupal.org/project/entity_embed): Embed entities in WYSIWYG
* [Linkit](https://www.drupal.org/project/linkit): Enhanced linking experience
* [Media Entity](https://www.drupal.org/project/media_entity): Media management
