# Security Update - JavaScript Plugin Changes

## What Was Updated

The CKEditor 5 MediaSwapper plugin has been updated to work with the new security requirements implemented in the API endpoints.

## Changes Made

### 1. Security Token Management
- Added `getSecurityTokens()` method to fetch CSRF tokens and user context from `/media-api/security-tokens`
- Tokens are cached for 5 minutes to reduce server requests
- Automatic token refresh when expired

### 2. Secure API Requests
- Added `makeSecureApiRequest()` method that:
  - Fetches security tokens automatically
  - Adds `csrf_token` and `user_uuid` to request body
  - Sets proper headers (`X-CSRF-Token`, `Origin`, `Content-Type`)
  - Handles errors gracefully with user-friendly messages

### 3. Updated API Calls
- `handleImageConversion()` now uses secure API requests
- `handleFileLink()` now uses secure API requests
- Both methods provide better error messages to users

## How It Works Now

1. **User clicks "Convert to Media" button**
2. **Plugin fetches security tokens** from `/media-api/security-tokens`
3. **Plugin makes secure API request** with:
   - CSRF token in both header and body
   - User UUID for verification
   - Proper origin header
   - JSON content type
4. **Server validates all security requirements**
5. **Conversion proceeds if all validations pass**

## User Experience

- Users may see a brief "Failed to get security tokens" message if they don't have proper permissions
- Better error messages explain what went wrong
- Process is transparent - users don't need to do anything different

## Files Changed

- `js/ckeditor5_plugins/mediaSwapper/src/MediaSwapper.js` - Updated JavaScript plugin
- `js/build/mediaSwapper.js` - Rebuilt production JavaScript

## Testing

The plugin now works with:
- ✅ CSRF token validation
- ✅ User context verification
- ✅ Origin header validation
- ✅ Rate limiting protection
- ✅ Proper permission checks

## Troubleshooting

### Common Issues Fixed:

1. **"Failed to get security tokens" Error**:
   - Fixed PHP Fatal error with property type conflicts
   - Fixed UserSession::uuid() method not found error
   - Fixed logger property type issues

2. **"Error parsing URL" JavaScript Error**:
   - Fixed `isAbsoluteUrl()` method to handle null/undefined/empty URLs
   - Added proper validation before URL parsing

### If users still get security errors:

1. **Check user permissions**: Users need `create media` and `update media` permissions
2. **Clear browser cache**: Old JavaScript may be cached  
3. **Check browser console**: Look for specific error messages
4. **Verify module permissions**: Ensure the security settings are configured properly
5. **Check server logs**: Look for PHP errors in DDEV logs (`ddev logs`)

### Recent Fixes Applied:

- ✅ Fixed SwapperController property conflicts with parent class
- ✅ Fixed user UUID retrieval by loading user entity properly
- ✅ Fixed SwapperService logger property type declaration
- ✅ Fixed JavaScript URL parsing to handle invalid/empty URLs
- ✅ Rebuilt JavaScript and cleared Drupal caches

## Development Notes

- JavaScript is built using webpack (`npm run build`)
- Security tokens are cached to prevent excessive server requests
- All API calls now go through the secure request method
- Error handling provides specific feedback to users