<?php

declare(strict_types=1);

namespace Drupal\Tests\image_to_media_swapper\Kernel;

use Drupal\image_to_media_swapper\SwapperService;
use Drupal\Tests\image_to_media_swapper\Traits\VfsFileTestTrait;

/**
 * Test-specific extension of SwapperService that handles VFS paths.
 */
class TestSwapperService extends SwapperService {

  use VfsFileTestTrait;

  /**
   * {@inheritdoc}
   */
  public function convertWebPathToPublicUri(string $filePath): ?string {
    // First try to handle VFS paths for tests.
    $vfsUri = $this->convertVfsPathToPublicUri($filePath);
    if ($vfsUri !== NULL) {
      return $vfsUri;
    }

    // Otherwise use the standard implementation.
    return parent::convertWebPathToPublicUri($filePath);
  }

}
