# Image Optimize - Thumbor v1.0.0

## Release Date
December 2025

## Description
The **Image Optimize - Thumbor** module provides seamless integration with the **Thumbor** image optimization service for the Image Optimize pipeline system in Drupal. This module enables real-time image optimization and transformation using Thumbor as a dedicated processor within Image Optimize pipelines, with native support for **Thumbor filesystem storage configurations**.

## Compatibility
- **Drupal Core**: 8.x, 9.x, 10.x, 11.x
- **PHP**: 7.4+ (recommended 8.0+)
- **Thumbor**: Compatible with filesystem-based Thumbor installations
- **Dependencies**:
  - Image Optimize (drupal.org/project/imageapi_optimize)
  - Drupal Core Image module

## Key Features in v1.0.0
- ✅ Official first release
- ✅ Full Thumbor integration with Image Optimize pipelines
- ✅ Custom ImageAPIOptimizeProcessor plugin for Thumbor
- ✅ Dedicated image effect plugin for simplified configuration
- ✅ Centralized ThumborService for URL generation and management
- ✅ **Full support for Thumbor filesystem-based storage**
- ✅ URL signature generation with optional Security Key authentication
- ✅ Native integration with Drupal image styles
- ✅ Operations string building from image style effects (resize, format conversion, etc.)
- ✅ Automatic path resolution for filesystem Thumbor configurations
- ✅ Web-accessible path generation for images in Drupal's public file directory

## Installation
1. Download the module from drupal.org
2. Extract to `/modules/custom/` (or `/modules/contrib/`)
3. Enable via admin UI (`/admin/modules`) or CLI:
   ```bash
   drush en imageapi_optimize_thumbor
   ```
4. Clear Drupal cache

## Configuration

### Basic Setup
1. Navigate to **Administration » Configuration » Media » Image Optimize pipelines** (`/admin/config/media/image_optimize`)
2. Create a new pipeline or edit an existing one
3. Add a new **Thumbor** processor
4. Configure the following fields:
   - **Thumbor Server URL**: e.g., `http://thumbor.example.com` or `https://thumbor.example.com`
   - **Security Key** (optional): Required if your Thumbor server has authentication enabled

### Thumbor Filesystem Configuration
This module is designed to work with **filesystem-based Thumbor installations**. The module automatically:
- Resolves image URIs from Drupal's public file directory
- Generates proper relative paths for Thumbor to access files via the filesystem
- Constructs web-accessible paths compatible with Thumbor's storage configuration

**Example Thumbor Setup (filesystem-based):**
```
Thumbor Server URL: http://thumbor.internal.local:8888
Images stored in: /var/www/shared/files/ (accessible via http://thumbor.internal.local:8888/sites/default/files/)
Drupal files directory: /var/www/html/sites/default/files
```

The module automatically maps Drupal image URIs (e.g., `public://images/photo.jpg`) to the correct filesystem paths that Thumbor expects.

### Image Style Configuration
1. Configure image effects (scale, crop, format conversion) as usual
2. The module automatically converts these to Thumbor operations:
   - **image_scale** → `fit-in/WxH`
   - **image_scale_and_crop** → `WxH`
   - **image_convert** → `filters:format(webp)`

## URL Generation & Security

### Without Security Key (Unsafe Mode)
```
http://thumbor.example.com/unsafe/300x200/sites/default/files/images/photo.jpg
```

### With Security Key (Signed URLs)
```
http://thumbor.example.com/SIGNATURE/300x200/sites/default/files/images/photo.jpg
```
- Uses HMAC-SHA1 signature generation
- Base64 URL-safe encoding for compatibility

## System Requirements
- **Active Thumbor server** (filesystem-based or compatible)
- **Network connectivity** from Drupal server to Thumbor server
- **Image Optimize** module installed and enabled
- **Public file directory** accessible to Thumbor via configured storage path
- **Proper file permissions** for Thumbor to read image files

## Security Considerations
- Always configure a **Security Key** in production environments
- Ensure Thumbor URL is only accessible from trusted networks/servers
- Test connectivity between Drupal and Thumbor before deploying to production
- Monitor Thumbor logs for unauthorized requests
- Keep Thumbor and Drupal servers synchronized regarding file paths

## Architecture

### Components
- **ThumborProcessor Plugin**: Implements the Image Optimize processor interface
- **ThumborService**: Central service for URL generation and configuration management
- **ThumborImageEffect**: Direct image style effect for standalone usage
- **Configuration Schema**: YAML-based configuration validation

### Request Flow
1. Image style with Thumbor processor is applied
2. Module detects Thumbor processor in pipeline or image effect
3. ThumborService resolves image URI to filesystem path
4. Operations string is built from image effects
5. Thumbor URL is generated with optional signature
6. URL is returned without modifying the original file

## Troubleshooting

### Common Issues
- **Thumbor URL returns 404**: Verify Thumbor server URL is correct and accessible
- **Image not found errors**: Check file permissions and Thumbor storage configuration
- **Signature errors**: Ensure Security Key matches between Drupal and Thumbor configuration
- **Path resolution errors**: Verify Drupal's public file directory is accessible to Thumbor

## Support & Reporting
- **Project Page**: https://drupal.org/project/imageapi_optimize_thumbor
- **Issue Queue**: https://drupal.org/project/issues/imageapi_optimize_thumbor
- **Documentation**: See included README.md

## Changelog

```
1.0.0 (December 2025)
- Initial official release
- Full Thumbor integration for Image Optimize pipelines
- Filesystem-based Thumbor configuration support
- ImageAPIOptimizeProcessor plugin implementation
- ThumborService for centralized URL management
- HMAC-SHA1 signature generation with Security Key support
- Operations string builder for image effects
- Complete configuration schema
- Support for Drupal 8, 9, 10, 11
```

## Roadmap (Future Enhancements)
- Advanced Thumbor filters and effects support
- Image transformation caching layer
- Request monitoring and analytics
- Additional storage backend support (S3, etc.)
- WebP and AVIF format detection
- Batch image optimization utilities

## Author & Maintenance
Module maintained by the Drupal community. Contributions welcome!
