# Images Import

The **Images Import** module provides an interface for importing images
on entities in Drupal. It allows us to replace or update images attached to
content types, users or other entities. Upload a CSV file with
the entity_title and image_url columns. Optionally, include an
entity_id column to import images based on the entity ID instead of the title.

## Table of contents

- Requirements
- Installation
- Configuration
- Maintainers

## Requirements

This module requires no modules outside of Drupal core.

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration

1. Navigate to **Content** > **Image Update/Import**
    (`/admin/content/image-import`).
2. Upload a CSV file with two required columns: "entity_title" and "image_url".
3. Select the entity type, its bundle, and the image fields to update.
4. If updating multiple images, check "Is Multiple?".
5. Click **Save and Import**.

### To remove existing images from entities

1. Navigate to **Content** > **Remove Existing Images**
    (`/admin/content/remove-existing-images`).
2. Upload a CSV file with the column "entity_title".
3. Select the entity type, its bundle, and the image fields
    whose values you want to remove.
4. Click **Save and Remove Images**.

### To update or import user images:

1. Navigate to **People** > **Update/Import User Images**
    (`/admin/config/people/user-image-import`).
2. Upload a CSV file with "entity_title" and "image_url" columns.
3. Select the user entity and the image field to update.
4. Click **Save and Import**.

### To remove user's existing images:

1. Navigate to **People** > **Remove Existing Images**
    (`/admin/config/people/remove-existing-user-images`).
2. Upload a CSV file with the "entity_title" column.
3. Select the user entity and the image field whose values you want to remove.
4. Click **Save and Remove Images**.

## Maintainers

- Sanket prajapati - [sanketprajapati](https://www.drupal.org/u/sanketprajapati)
