<?php

namespace Drupal\images_import\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Response;

/**
 * Returns responses for Image Import routes.
 */
class DemoCsvController extends ControllerBase {

  /**
   * Provides demo CSV download.
   */
  public function demoCsv() {
    $csv_content = "entity_id,entity_title,image_url\n1,test entity1,https://example.com/images/product1.jpg\n2,test entity2,https://example.com/images/product2.png\n3,test entity3,https://example.com/images/product3.webp";

    $response = new Response($csv_content);
    $response->headers->set('Content-Type', 'text/csv');
    $response->headers->set('Content-Disposition', 'attachment; filename="demo-image-import.csv"');

    return $response;
  }

  /**
   * Provides demo csv for multiple images.
   */
  public function demoMultipleImageCsv() {
    $csv_content = "entity_id,entity_title,image_url\r\n1,Test Entity 1,\"https://example.com/images/product1.jpg,https://example.com/images/product2.png\"\r\n2,test entity2,\"https://example.com/images/product3.webp,https://example.com/images/product4.jpg\"\r\n3,test entity3,\"https://example.com/images/product5.png,https://example.com/images/product6.webp\"";

    $response = new Response($csv_content);
    $response->headers->set('Content-Type', 'text/csv');
    $response->headers->set('Content-Disposition', 'attachment; filename="demo-multiple-image-import.csv"');

    return $response;
  }

}
