<?php

namespace Drupal\immich_integration\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\immich_integration\Service\ImmichClient;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Controller for Immich integration test pages.
 */
class ImmichTestController extends ControllerBase {

    /**
     * The Immich client service.
     *
     * @var \Drupal\immich_integration\Service\ImmichClient
     */
    protected $immichClient;

    /**
     * Constructs an ImmichTestController object.
     *
     * @param \Drupal\immich_integration\Service\ImmichClient $immich_client
     *   The Immich client service.
     */
    public function __construct(ImmichClient $immich_client) {
        $this->immichClient = $immich_client;
    }

    /**
     * {@inheritdoc}
     */
    public static function create(ContainerInterface $container) {
        return new static(
            $container->get('immich_integration.client')
        );
    }

    /**
     * Test connection to Immich server.
     *
     * @return \Symfony\Component\HttpFoundation\JsonResponse
     *   JSON response with connection test results.
     */
    public function testConnection() {
        $result = $this->immichClient->testConnection();
        $server_info = $this->immichClient->getServerInfo();

        if ($server_info) {
            $result['server_info'] = $server_info;
        }

        return new JsonResponse($result);
    }

}
