<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\Hook;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\FieldableEntityInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\inline_image_saver\InlineImageSaverInterface;

/**
 * Hook implementations for image_field_caption.
 */
class InlineImageSaverHooks {

  public function __construct(protected readonly InlineImageSaverInterface $inlineImageSaver) {}

  /**
   * Implements hook_field_info_alter().
   */
  #[Hook('field_info_alter')]
  public function fieldInfoAlter(array &$info): void {
    if (!$this->inlineImageSaver->getSetting('enable_validation')) {
      return;
    }
    foreach ($info as &$definition) {
      if ($this->inlineImageSaver->isFieldTypeProcessable($definition['class'])) {
        $definition['constraints']['InlineImageSaver'] = [];
      }
    }
  }

  /**
   * Implements hook_entity_presave().
   */
  #[Hook('entity_presave')]
  public function entityPresave(EntityInterface $entity): void {
    if (!$entity instanceof FieldableEntityInterface) {
      return;
    }
    if ($this->inlineImageSaver->isEntityProcessable($entity)) {
      $this->inlineImageSaver->processEntity($entity);
    }
  }

}
