<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver;

use Drupal\file\FileInterface;
use Drupal\inline_image_saver\Struct\InlineImageData;

/**
 * Defines an interface for finding existing files that match inline images.
 */
interface InlineImageFinderInterface {

  /**
   * The hash algorithm used for content comparison.
   *
   * @var string
   */
  public const HASH_ALGO = 'xxh128';

  /**
   * Finds an existing file by comparing content hashes.
   *
   * @param \Drupal\inline_image_saver\Struct\InlineImageData $data
   *   The inline image data containing content to match.
   *
   * @return \Drupal\file\FileInterface|null
   *   The matching file entity if found, NULL otherwise.
   */
  public function findByHash(InlineImageData $data): ?FileInterface;

  /**
   * Finds an existing file by matching source URL and content hash.
   *
   * @param \Drupal\inline_image_saver\Struct\InlineImageData $data
   *   The inline image data containing source URL and content.
   *
   * @return \Drupal\file\FileInterface|null
   *   The matching file entity if found, NULL otherwise.
   */
  public function findBySrc(InlineImageData $data): ?FileInterface;

}
