<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver;

use Drupal\inline_image_saver\MimeType\InlineImageMimeResolverInterface;

/**
 * Defines an image MIME type resolver that delegates to a chain of resolvers.
 */
interface InlineImageMimeInterface extends InlineImageMimeResolverInterface {

  /**
   * Adds a MIME type resolver to the resolver chain.
   *
   * @param \Drupal\inline_image_saver\MimeType\InlineImageMimeResolverInterface $resolver
   *   The resolver to add.
   * @param int $priority
   *   (optional) The priority of the resolver. Higher comes first.
   *
   * @return $this
   */
  public function addMimeResolver(InlineImageMimeResolverInterface $resolver, int $priority = 0): static;

}
