<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\MimeType;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Provides an image MIME type resolver using the PHP 'fileinfo' extension.
 */
class InlineImageFileInfoMimeResolver extends InlineImageMimeResolverBase {

  /**
   * A fileinfo instance.
   */
  protected \finfo $finfo;

  /**
   * {@inheritdoc}
   */
  public function isSupported(?TranslatableMarkup &$reason = NULL): bool {
    $reason = NULL;
    if (\function_exists('finfo_open')) {
      return TRUE;
    }
    $reason = $this->t('The "<code>fileinfo</code>" PHP extension is not available in the current environment.');
    return FALSE;
  }

  /**
   * {@inheritdoc}
   */
  protected function doResolveByUri(string $uri): ?string {
    return $this->getFileInfo()->file($uri);
  }

  /**
   * {@inheritdoc}
   */
  protected function doResolveByData(string $data): ?string {
    return $this->getFileInfo()->buffer($data);
  }

  /**
   * Returns the fileinfo instance.
   *
   * @return \finfo
   *   The fileinfo instance.
   */
  protected function getFileInfo(): \finfo {
    return $this->finfo ??= new \finfo(\FILEINFO_MIME_TYPE);
  }

}
