<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\MimeType;

use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Defines an interface for resolving image MIME types.
 */
interface InlineImageMimeResolverInterface {

  /**
   * Checks if the MIME type resolver is available.
   *
   * @param \Drupal\Core\StringTranslation\TranslatableMarkup|null $reason
   *   (optional) Populated with a translatable explanation if unsupported.
   *
   * @return bool
   *   TRUE if image MIME type resolution is supported, FALSE otherwise.
   */
  public function isSupported(?TranslatableMarkup &$reason = NULL): bool;

  /**
   * Determines if file URI represents an image by resolving its MIME type.
   *
   * @param string $uri
   *   The file URI to analyze.
   * @param string|null $mime_type
   *   (optional) Populated with the resolved MIME type.
   *
   * @return bool
   *   TRUE if the URI is an image, FALSE otherwise.
   */
  public function resolveByUri(string $uri, ?string &$mime_type = NULL): bool;

  /**
   * Determines if binary data represents an image by resolving its MIME type.
   *
   * @param string $data
   *   The binary data to analyze.
   * @param string|null $mime_type
   *   (optional) Populated with the resolved MIME type.
   *
   * @return bool
   *   TRUE if the data is an image, FALSE otherwise.
   */
  public function resolveByData(string $data, ?string &$mime_type = NULL): bool;

}
