<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\Plugin\Validation\Constraint;

use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;
use Symfony\Component\Validator\Constraint as SymfonyConstraint;

/**
 * Provides an InlineImageSaver constraint.
 */
#[Constraint(
  id: 'InlineImageSaver',
  label: new TranslatableMarkup('Inline Image Saver', ['context' => 'Validation']),
)]
class InlineImageSaverConstraint extends SymfonyConstraint {

  /**
   * Character limit for data URI images in validation messages.
   */
  public int $dataUriCharLimit = 10;

  /**
   * Character limit for image URL paths in validation messages.
   */
  public int $urlPathCharLimit = 100;

  /**
   * Message shown when an unknown image validation error occurs.
   */
  public string $messageUnknown = 'The image <a href=":url" target="@target">@name</a> is invalid.';

  /**
   * Message shown when the data URI contains invalid image data.
   */
  public string $messageInvalidDataUriValue = 'The image "@name" is invalid: broken data URI.';

  /**
   * Message shown when the data URI contains an unsupported MIME type.
   */
  public string $messageUnsupportedDataUriMimeType = 'The image "@name" is invalid: unsupported data URI type.';

  /**
   * Message shown when data URI images are not allowed.
   */
  public string $messageDataUriNotAllowed = 'The image "@name" is invalid: data URIs are not allowed.';

  /**
   * Message shown when the data-entity-type attribute is empty.
   */
  public string $messageEmptyEntityTypeAttribute = 'The image <a href=":url" target="@target">@name</a> is invalid: empty <code>data-entity-type</code> attribute. The image must contain valid <code>data-entity-type</code> and <code>data-entity-uuid</code> attributes referencing an existing file entity.';

  /**
   * Message shown when the data-entity-type attribute is unsupported.
   */
  public string $messageUnsupportedEntityTypeAttribute = 'The image <a href=":url" target="@target">@name</a> is invalid: unsupported <code>data-entity-type</code> attribute. The image must contain valid <code>data-entity-type</code> and <code>data-entity-uuid</code> attributes referencing an existing file entity.';

  /**
   * Message shown when the data-entity-uuid attribute is empty.
   */
  public string $messageEmptyEntityUuid = 'The image <a href=":url" target="@target">@name</a> is invalid: empty <code>data-entity-uuid</code> attribute. The image must contain valid <code>data-entity-type</code> and <code>data-entity-uuid</code> attributes referencing an existing file entity.';

  /**
   * Message shown when the referenced entity cannot be found.
   */
  public string $messageEntityNotFound = 'The image <a href=":url" target="@target">@name</a> is invalid: referenced entity not found. The image must contain valid <code>data-entity-type</code> and <code>data-entity-uuid</code> attributes referencing an existing file entity.';

  /**
   * Message shown when the referenced file cannot be found.
   */
  public string $messageFileNotFound = 'The image <a href=":url" target="@target">@name</a> is invalid: the referenced file is not found.';

  /**
   * Message shown when the referenced file has supported MIME type.
   */
  public string $messageUnsupportedFileMime = 'The image <a href=":url" target="@target">@name</a> is invalid: the referenced file has an unsupported MIME type.';

  /**
   * Message shown when the image URL host does not match the expected value.
   */
  public string $messageUrlHostMismatch = 'The image <a href=":url" target="@target">@name</a> is invalid: URL host mismatch. The referenced file entity generates a different host.';

  /**
   * Message shown when the image URL path does not match the expected value.
   */
  public string $messageUrlPathMismatch = 'The image <a href=":url" target="@target">@name</a> is invalid: URL path mismatch. The referenced file entity generates a different path.';

  /**
   * Message shown when the image URL query does not match the expected value.
   */
  public string $messageUrlQueryMismatch = 'The image <a href=":url" target="@target">@name</a> is invalid: URL query mismatch. The referenced file entity generates a different query string.';

}
