<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\Struct;

/**
 * Value object containing inline image data and metadata.
 */
class InlineImageData {

  /**
   * Constructs the object.
   *
   * @param \DOMElement $img
   *   The source <img> element.
   * @param string $data
   *   The binary image data.
   * @param string $mime_type
   *   The image MIME type (e.g., 'image/jpeg').
   * @param string|null $src
   *   The image URL used for downloading, if applicable.
   */
  public function __construct(
    public readonly \DOMElement $img,
    public readonly string $data,
    public readonly string $mime_type,
    public readonly ?string $src,
  ) {}

}
