<?php

declare(strict_types=1);

namespace Drupal\inline_image_saver\Struct;

/**
 * Enumerated validation error codes for inline images.
 */
enum InlineImageError {
  case Unknown;
  case InvalidDataUriValue;
  case UnsupportedDataUriMimeType;
  case DataUriNotAllowed;
  case EmptyEntityTypeAttribute;
  case UnsupportedEntityTypeAttribute;
  case EmptyEntityUuid;
  case EntityNotFound;
  case FileNotFound;
  case UnsupportedFileMime;
  case UrlHostMismatch;
  case UrlPathMismatch;
  case UrlQueryMismatch;
}
