<?php

/**
 * @file
 * Hooks provided by the inline_svg module.
 */

/**
 * Alter the list of dangerous patterns for SVG validation.
 *
 * Other modules may implement this hook to add, remove, or modify
 * the dangerous patterns used for SVG code validation.
 *
 * @param array &$patterns
 *   An associative array of dangerous patterns keyed by the pattern string.
 *   Each value is a human-readable message explaining why it is disallowed.
 *
 * @code
 *   // Add a new dangerous pattern.
 *   $patterns['data:'] = 'Data URLs are not allowed in SVG code.';
 *
 *   // Modify an existing pattern message.
 *   if (isset($patterns['<script'])) {
 *     $patterns['<script'] = 'Custom message for <script> tags.';
 *   }
 *
 *   // Remove a dangerous pattern.
 *   unset($patterns['onclick']);
 *
 *   // Example implementation in another module:
 *   function mymodule_svg_dangerous_patterns_alter(array &$patterns) {
 *     $patterns['data:'] = 'Data URLs are not allowed in SVG code.';
 *     unset($patterns['onmouseover']);
 *   }
 * @endcode
 */
function hook_svg_dangerous_patterns_alter(array &$patterns) {
}

/**
 * Alter the list of allowed SVG tags for XSS filtering.
 *
 * Other modules can implement this hook to add, remove, or modify
 * the allowed SVG tags used when filtering SVG code.
 *
 * @param array &$allowed_tags
 *   An array of allowed SVG tag names as strings.
 *
 * @code
 *   // Add a new allowed tag.
 *   $allowed_tags[] = 'filter';
 *
 *   // Remove an allowed tag.
 *   if (($key = array_search('switch', $allowed_tags)) !== FALSE) {
 *     unset($allowed_tags[$key]);
 *   }
 *
 *   // Example implementation in another module:
 *   function mymodule_svg_allowed_tags_alter(array &$allowed_tags) {
 *     $allowed_tags[] = 'filter';
 *     $allowed_tags = array_unique($allowed_tags);
 *   }
 * @endcode
 */
function hook_svg_allowed_tags_alter(array &$allowed_tags) {
}
