<?php

namespace Drupal\inline_svg_media\Form;

use Drupal\Core\Form\FormBuilderInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Url;
use Drupal\media_library\Form\AddFormBase;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Media library add form.
 */
class SvgCodeAddForm extends AddFormBase {

  /**
   * The logger for inline_svg_media.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected $logger;

  /**
   * {@inheritdoc}
   */
  public function __construct($entity_type_manager, $library_ui_builder, $opener_resolver, LoggerInterface $logger) {
    parent::__construct($entity_type_manager, $library_ui_builder, $opener_resolver);
    $this->logger = $logger;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager'),
      $container->get('media_library.ui_builder'),
      $container->get('media_library.opener_resolver'),
      $container->get('logger.factory')->get('inline_svg_media')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return $this->getBaseFormId() . '_svg_code';
  }

  /**
   * {@inheritdoc}
   */
  protected function buildInputElement(array $form, FormStateInterface $form_state): array {

    // Add a container to group the input elements for styling purposes.
    $form['container'] = [
      '#type' => 'container',
    ];

    $form['container']['svg_code'] = [
      '#type' => 'textarea',
      '#title' => $this->t('SVG Code'),
      '#description' => $this->t('Enter the full SVG markup to display on the page.'),
      '#default_value' => '',
      '#required' => TRUE,
    ];
    $form['container']['svg_code_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('SVG Code Name'),
      '#description' => $this->t('Enter the SVG markup name.'),
      '#default_value' => '',
      '#required' => TRUE,
    ];

    $form['container']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Add'),
      '#button_type' => 'primary',
      '#submit' => ['::addButtonSubmit'],
      '#ajax' => [
        'callback' => '::updateFormCallback',
        'wrapper' => 'media-library-wrapper',
        'url' => Url::fromRoute('media_library.ui'),
        'options' => [
          'query' => $this->getMediaLibraryState($form_state)->all() + [
            FormBuilderInterface::AJAX_FORM_REQUEST => TRUE,
          ],
        ],
      ],
    ];

    return $form;
  }

  /**
   * Submit handler for the add button.
   *
   * @param array $form
   *   The form render array.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   */
  public function addButtonSubmit(array $form, FormStateInterface $form_state): void {
    $this->processInputValues([[
      'svg' => $form_state->getValue('svg_code'),
      'name' => $form_state->getValue('svg_code_name'),
    ],
    ], $form, $form_state);
  }

}
