<?php

namespace Drupal\inline_svg_media\Plugin\media\Source;

use Drupal\Core\Entity\Display\EntityViewDisplayInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\media\Attribute\MediaSource;
use Drupal\media\MediaTypeInterface;
use Drupal\media\MediaSourceBase;

/**
 * Media source plugin for raw SVG code input.
 */
#[MediaSource(
  id: "svg_code",
  label: new TranslatableMarkup("SVG Code"),
  description: new TranslatableMarkup("Use raw SVG code as reusable media."),
  allowed_field_types: ["svg_code"],
  forms: [
    "media_library_add" => "\Drupal\inline_svg_media\Form\SvgCodeAddForm",
  ]
)]
class SvgCodeMediaSource extends MediaSourceBase {

  /**
   * {@inheritdoc}
   */
  public function createSourceField(MediaTypeInterface $type) {

    /** @var \Drupal\field\FieldConfigInterface $field */
    $field = parent::createSourceField($type);

    // Reset the field to its default settings so that we don't inherit the
    // settings from the parent class' source field.
    $settings = $this->fieldTypeManager->getDefaultFieldSettings($field->getType());

    return $field->set('settings', $settings);
  }

  /**
   * {@inheritdoc}
   */
  public function prepareViewDisplay(MediaTypeInterface $type, EntityViewDisplayInterface $display) {
    $display->setComponent($this->getSourceFieldDefinition($type)->getName(), [
      'type' => 'svg_code_formatter',
      'label' => 'visually_hidden',
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public function getMetadataAttributes() {
    return [
      'svg' => $this->t('SVG code'),
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getMetadata($media, $attribute_name) {
    if ($attribute_name === 'svg') {
      return $media->getSource()->getSourceFieldValue($media);
    }

    // var_dump($attribute_name);
    $icon = $media
      ->get($this->configuration['source_field'])
      ->first();

    switch ($attribute_name) {
      case 'default_name':
        return $icon->getValue()['name'];

      // Case 'thumbnail_uri':
      // return $icon->getValue()['svg'];
      default:
        return parent::getMetadata($media, $attribute_name);
    }

    return parent::getMetadata($media, $attribute_name);
  }

}
