(function ($, Drupal) {
  Drupal.behaviors.svgPreviewModal = {
    attach: function (context, settings) {
      once('svg_code_preview_link', '.svg-code-preview-link', context).forEach(
        function (linkElement) {
          const $link = $(linkElement);

          $link.on('click', function (e) {
            e.preventDefault();

            const textareaClass = $(this).attr('data-textarea-class');
            const $textarea = $('.' + textareaClass);

            if ($textarea.length === 0) {
              alert('SVG textarea not found.');
              return;
            }

            const svgContent = $textarea.val().trim();

            if (!svgContent) {
              alert('SVG code is empty.');
              return;
            }

            // Sanitize SVG: Remove <script> tags
            const sanitizedSvg = $('<div>').html(svgContent);
            sanitizedSvg.find('script').remove(); // Remove any <script> tags

            const modalContent = $('<div class="svg-preview-modal-content">')
              .html(sanitizedSvg)
              .css({
                width: '100%',
                height: '100%',
                'text-align': 'center',
                'max-width': '900px',
                'min-width': '300px',
                margin: '0 auto',
              });

            // Show the modal dialog
            Drupal.dialog(modalContent.get(0), {
              title: 'SVG Preview',
              width: 'auto',
              buttons: [
                {
                  text: 'Close',
                  click: function () {
                    $(this).dialog('close');
                  },
                },
              ],
            }).showModal();
          });
        }
      );

      once(
        'svg_code_download_link',
        '.svg-code-download-link',
        context
      ).forEach(function (linkElement) {
        const $link = $(linkElement);

        $link.on('click', function (e) {
          e.preventDefault();

          const textareaClass = $(this).attr('data-textarea-class');
          const $textarea = $('.' + textareaClass);

          if ($textarea.length === 0) {
            alert('SVG textarea not found.');
            return;
          }

          let svgContent = $textarea.val().trim();

          if (!svgContent) {
            alert('SVG code is empty.');
            return;
          }

          // Create a DOM element to sanitize the SVG
          const wrapper = document.createElement('div');
          wrapper.innerHTML = svgContent;

          // Remove <script> tags
          wrapper.querySelectorAll('script').forEach((el) => el.remove());

          // Optionally remove dangerous attributes (onload, onclick, etc.)
          wrapper.querySelectorAll('*').forEach((el) => {
            // Clone attributes to safely iterate
            Array.from(el.attributes).forEach((attr) => {
              const attrName = attr.name.toLowerCase();
              if (
                attrName.startsWith('on') ||
                attr.value.toLowerCase().includes('javascript:')
              ) {
                el.removeAttribute(attr.name);
              }
            });
          });

          // Get sanitized SVG string
          const sanitizedSvg = wrapper.innerHTML.trim();

          // Create and trigger the download
          const blob = new Blob([sanitizedSvg], {
            type: 'image/svg+xml;charset=utf-8',
          });
          const url = URL.createObjectURL(blob);

          const a = document.createElement('a');
          a.href = url;
          a.download = $(this).attr('download');
          document.body.appendChild(a);
          a.click();
          document.body.removeChild(a);

          URL.revokeObjectURL(url);
        });
      });
    },
  };
})(jQuery, Drupal);
