<?php

namespace Drupal\inqube\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Prints Elasticsearch query to console for debugging.
 *
 * @ingroup ajax
 */
class ElasticsearchDebugCommand implements CommandInterface {

  /**
   * The text to output.
   *
   * @var string|array
   */
  protected string|array $text;

  /**
   * ElasticsearchDebugCommand constructor.
   *
   * @param $text
   *   The text to output.
   */
  public function __construct($text) {
    $this->text = $text;
  }

  /**
   * Implements \Drupal\Core\Ajax\CommandInterface:render().
   */
  public function render() {
    return [
      'command' => 'elasticsearch_query_debug',
      'text' => $this->text,
    ];
  }

}
