<?php

/**
 * @file
 * Contains \Drupal\instapage_cms_plugin\Controller\InstapagePluginController.
 */

namespace Drupal\instapage_cms_plugin\Controller;

use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * Base plugin controller.
 */
class InstapagePluginController extends ControllerBase {

  public function content()
  {

    ob_start();
    \InstapageCmsPluginConnector::getSelectedConnector()->loadPluginDashboard();
    $content = ob_get_contents();
    ob_end_clean();

    $build = array(
      '#markup' => $content,
      '#attached' => array(
        'library' =>  array(
          'instapage_cms_plugin/instapage_cms_plugin_library'
        )
      )
    );

    return $build;
  }

  public function handleRequest(Request $request) {
    $postData = $request->request->all();
    $post = isset($postData['data']) ? json_decode(urldecode($postData['data'])) : new \stdClass();
    $post->data = isset($post->data) ? $post->data : null;
    $action = isset($post->action) ? $post->action : null;

    header('Content-Type: application/json');

    ob_start();

    try {
      if (!empty($action)) {
        \InstapageCmsPluginAjaxController::getInstance()->doAction($action, $post->data);
      } else {
        echo \InstapageCmsPluginHelper::formatJsonMessage('Action is missing. Refreshing the page usually helps. If the error returns, contact the Instapage Support Team.', 'ERROR');
      }
    } catch (\Exception $e) {
      \InstapageCmsPluginHelper::writeDiagnostics($e->getMessage(), 'Drupal ajax entry point to AJAX request handler exception.');
      echo \InstapageCmsPluginHelper::formatJsonMessage('Server error. Refreshing the page usually helps. If the error returns, contact the Instapage Support Team.', 'ERROR');
    }

    $responseContent = ob_get_clean();

    return new Response($responseContent);
  }
}
