# Interface Translation Auto

Translates untranslated interface strings in batch using the DeepL API.

This module adds a "Translate untranslated strings" link on the Languages page
and runs a batch to translate all missing interface strings from English to the
selected language.

## Requirements
- Drupal core: 10 or 11
- Modules: Language, Locale

## Configuration
This module stores its own DeepL settings in `interface_translation_auto.settings`.

1. Configure the translation provider and API credentials:
   - `/admin/config/regional/interface-translation-auto`
2. Ensure the "Translate interface text" permission is granted.

## Usage
1. Go to `/admin/config/regional/language`.
2. In the "Interface translation" column, click
   "Translate untranslated strings" for the desired language.
3. The batch process will translate all missing strings.

## Notes
- English is the source language and is not translated.
- Large sites may take time; the batch runs in chunks.
- When using OpenAI, available models are GPT-5.2, GPT-5.2-mini, and GPT-5.2-nano.

## Permissions
- `translate interface`
