<?php

declare(strict_types=1);

namespace Drupal\interface_translation_auto\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Url;
use Drupal\language\ConfigurableLanguageInterface;

/**
 * Starts the batch translation of untranslated interface strings.
 */
class InterfaceTranslationAutoController extends ControllerBase {

  /**
   * Starts the DeepL translation batch for a specific language.
   */
  public function start(ConfigurableLanguageInterface $configurable_language) {
    $langcode = $configurable_language->id();

    if ($langcode === 'en') {
      $this->messenger()->addWarning($this->t('English is the source language and does not require translation.'));
      return $this->redirect('entity.configurable_language.collection');
    }

    interface_translation_auto_start_batch($langcode, $configurable_language->label());

    return batch_process(Url::fromRoute('entity.configurable_language.collection')->toString());
  }

}
