<?php

namespace Drupal\interstitial\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for the Interstitial module.
 */
class InterstitialSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['interstitial.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'interstitial_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    $config = $this->config('interstitial.settings');

    $form['message'] = [
      '#type' => 'textarea',
      '#title' => $this->t('Interstitial message template'),
      '#default_value' => $config->get('message') ?: 'You are now leaving the site {site}. Click below to continue to {url}.',
      '#description' => $this->t('Use placeholders {site} and {url}.'),
      '#required' => TRUE,
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->configFactory()->getEditable('interstitial.settings')
      ->set('message', $form_state->getValue('message'))
      ->save();
    parent::submitForm($form, $form_state);
  }

}
