<?php

namespace Drupal\intl_date;

use Twig\Extension\AbstractExtension;
use Twig\TwigFilter;

/**
 * Format dates in Twig templates using Intl.
 */
class TwigExtension extends AbstractExtension {

  /**
   * The IntlDate service.
   *
   * @var \Drupal\intl_date\IntlDate
   */
  protected IntlDate $service;

  public function __construct(IntlDate $intl_date) {
    $this->service = $intl_date;
  }

  /**
   * {@inheritdoc}
   */
  public function getName() {
    return 'intl_date.twig_extension';
  }

  /**
   * {@inheritdoc}
   */
  public function getFilters() {
    return [
      new TwigFilter('intl_format_date', $this->service->format(...)),
      new TwigFilter('intl_format_date_pattern', $this->service->formatPattern(...)),
    ];
  }

}
