/**
 * @file
 * Provides IO Browser view utilitiy functions.
 */

(function ($, Drupal, _d) {

  'use strict';

  var _nick = 'ib';
  var _isNick = 'is-' + _nick;
  var _viewswitch = 'viewswitch';
  var _id = _nick + '__' + _viewswitch;
  var _idSwitch = _nick + '-' + _viewswitch;
  var _onSwitch = _id + '--on';
  var _selSwitch = '.' + _id + ':not(.' + _onSwitch + ')';
  var _isActive = _isNick + '-active';
  var _isInfoActive = _isNick + '-info-active';
  var _isCollapsed = _isNick + '-collapsed';
  var _baseForm = '.form--' + _nick;
  var _selBtn = '.button';
  var _cHelp = 'view--ib-help';
  var _selIdSwitch = '#ib-' + _viewswitch;
  var _selView = '.view--' + _nick;
  var _blazy = Drupal.blazy || null;
  var _classes = '';
  var _elGrid = null;

  Drupal.ioBrowser = Drupal.ioBrowser || {};

  /**
   * IO Browser utility functions.
   *
   * @param {HTMLElement} switcher
   *   The switcher HTML element.
   */
  function fnViewSwitch(switcher) {
    var $switcher = $(switcher);
    var $form = $switcher.closest(_baseForm);
    var $container = $form.length ? $form : $switcher.closest(_selView);
    var $head = $('.ib__header');

    _elGrid = $container.find('.ib__grid:first');

    // Store original classes for the switcher.
    _classes = _elGrid.attr('class');


    /**
     * Switch the view display.
     *
     * @param {jQuery.Event} event
     *   The event triggered by a `click` event.
     */
    function switchView(event) {
      event.preventDefault();

      var $btn = $(event.currentTarget);
      var target = $btn.data('target');
      var $view = $(_selView);

      $btn.closest('.button-group').find(_selBtn).removeClass(_isActive);
      $btn.addClass(_isActive);

      if (target && $view.length) {
        $('.' + _isInfoActive).removeClass(_isInfoActive);

        if (target === 'help') {
          $container.removeClass(_isCollapsed);
          $container.toggleClass(_cHelp);
          $btn.text($container.hasClass(_cHelp) ? 'x' : '?');
        }
        else {
          $('.button--help', $container).text('?');
          $container.removeClass(_cHelp);
          $view.removeClass('view--ib-grid view--ib-list view--ib-help');
          _elGrid.attr('class', target === 'list' ? 'ib__grid' : _classes);
          $view.addClass('view--ib-' + target);

          // Revalidate potential clones.
          if (_blazy && _blazy.init !== null) {
            _blazy.init.revalidate(true);
          }
        }
      }
    }

    // If the switcher is embedded inside EB, append it to the form header.
    if ($head.length) {
      $head.find('.' + _id).remove();

      $switcher.addClass(_id + '--header').appendTo($head);
    }

    // The switcher can live within, or outside view, when EB kicks in.
    $(_selBtn, switcher).on('click.ibSwitch', switchView);

    // Makes the active button active.
    $(_selIdSwitch, $container).find('.button--view.' + _isActive).click();

    $switcher.addClass(_onSwitch);
  }

  /**
   * Attaches IO Browser view behavior to HTML element.
   *
   * @type {Drupal~behavior}
   */
  Drupal.behaviors.ioBrowserViewSwitch = {
    attach: function (context) {
      _d.once(fnViewSwitch, _idSwitch, _selSwitch, context);
    },
    detach: function (context, setting, trigger) {
      if (trigger === 'unload') {
        _d.once.removeSafely(_idSwitch, _selSwitch, context);
      }
    }
  };

})(jQuery, Drupal, dBlazy);
