<?php

namespace Drupal\ip_anon\Hook;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\ip_anon\IpAnonymizeInterface;

/**
 * Implements hook_cron().
 */
#[Hook('cron')]
class Cron {

  public function __construct(
    protected ConfigFactoryInterface $configFactory,
    protected IpAnonymizeInterface $ipAnonymize,
  ) {
  }

  /**
   * Implements hook_cron().
   */
  public function __invoke(): void {
    if ($this->configFactory->get('ip_anon.settings')->get('policy')) {
      $this->ipAnonymize->scrub();
    }
  }

}
