<?php

namespace Drupal\ip_anon\Hook;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\ip_anon\IpAnonymizeInterface;

/**
 * Implements hook_ip_anon_alter().
 */
class IpAnonAlter {

  public function __construct(
    protected EntityTypeManagerInterface $entityTypeManager,
    protected IpAnonymizeInterface $ipAnonymize,
  ) {
  }

  /**
   * Implements hook_ip_anon_alter() for comment module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'comment', 'comment')]
  public function comment(array &$tables): void {
    $tables['comment_field_data'] = [
      'hostname' => 'hostname',
      'timestamp' => 'changed',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for dblog module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'dblog', 'dblog')]
  public function dblog(array &$tables): void {
    $tables['watchdog'] = $this->ipAnonymize->getDefaultColumns();
  }

  /**
   * Implements hook_ip_anon_alter() for Commerce Order module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'commerceOrder', 'commerce_order')]
  public function commerceOrder(array &$tables): void {
    $tables['commerce_order'] = [
      'hostname' => 'ip_address',
      'timestamp' => 'changed',
      'callback' => function () {
        $this->entityTypeManager->getStorage('commerce_order')->resetCache();
      },
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for Login History module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'loginHistory', 'login_history')]
  public function loginHistory(array &$tables): void {
    $tables['login_history'] = [
      'hostname' => 'hostname',
      'timestamp' => 'login',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for simple_access_log module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'simpleAccessLog', 'simple_access_log')]
  public function simpleAccessLog(array &$tables): void {
    $tables['simple_access_log'] = [
      'hostname' => 'remote_host',
      'timestamp' => 'timestamp',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for Tether Stats module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'tetherStats', 'tether_stats')]
  public function tetherStats(array &$tables): void {
    $tables['tether_stats_activity_log'] = [
      'hostname' => 'ip_address',
      'timestamp' => 'created',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for Visitors module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'visitors', 'visitors')]
  public function visitors(array &$tables): void {
    $tables['visitors'] = [
      'hostname' => 'visitors_ip',
      'timestamp' => 'visitors_date_time',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for Voting API module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'votingapi', 'votingapi')]
  public function votingapi(array &$tables): void {
    $tables['votingapi_vote'] = [
      'hostname' => 'vote_source',
      'timestamp' => 'timestamp',
    ];
  }

  /**
   * Implements hook_ip_anon_alter() for webform module.
   *
   * @phpstan-ignore missingType.iterableValue
   */
  #[Hook('ip_anon_alter', 'webform', 'webform')]
  public function webform(array &$tables): void {
    $tables['webform_submission'] = [
      'hostname' => 'remote_addr',
      'timestamp' => 'changed',
      'callback' => function () {
        // @phpstan-ignore-next-line Webform is not yet a dev dependency.
        $this->entityTypeManager->getStorage('webform_submission')->resetCache();
      },
    ];
  }

}
