<?php

namespace Drupal\ip_anon\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Implements hook_help().
 */
#[Hook('help')]
class Help {

  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  public function __invoke(?string $route_name): ?TranslatableMarkup {
    return match ($route_name) {
      'help.page.ip_anon' => $this->t('IP Anonymize module enhances user privacy by implementing a retention policy for IP addresses recorded in the database.'),
      'ip_anon.settings' => $this->t('IP addresses recorded in the database can be scrubbed on each cron run according to the retention period configured for each database table.'),
      default => NULL,
    };
  }

}
