<?php

namespace Drupal\ip_anon;

/**
 * Provides ip_anon functionality.
 */
interface IpAnonymizeInterface {

  /**
   * Anonymize IP addresses which have exceeded the retention period.
   */
  public function scrub(): void;

  /**
   * Default array of hostname and timestamp columns.
   *
   * @return string[]
   *   Default columns.
   */
  public function getDefaultColumns(): array;

  /**
   * Array of tables and columns which store hostnames and timestamps.
   *
   * Modules may add tables by implementing hook_ip_anon_alter().
   *
   * @return array<string, array{hostname: string, timestamp: string, callback?: callable}>
   *   List of tables to be scrubbed.
   */
  public function getTables(): array;

  /**
   * Returns table description.
   */
  public function getTableDescription(string $table): string;

}
