<?php

/**
 * @file
 * Deploy functions for the ip_info module.
 */

use Drupal\Core\Site\Settings;

/**
 * If a setting or config found a new key will be created.
 */
function ip_info_deploy_0001_create_keys_te() {
  \Drupal::service('module_installer')->install(['key']);

  $settings = Settings::get('ip_info');
  $config = \Drupal::config('ip_info.settings');
  $config_names = [
    'ipinfo_io_token' => 'IPinfo.io token',
    'ipapi_is_key' => 'ipapi.is key',
    'ipgeolocation_io_key' => 'ipgeolocation.io key',
    'ipstack_com_key' => 'ipstack.com key',
  ];
  foreach ($config_names as $config_name => $config_label) {
    if ($settings && array_key_exists($config_name, $settings) && $settings[$config_name]) {
      create_new_key($config_name, $config_label, $settings[$config_name]);
    }
    elseif ($config->get($config_name)) {
      create_new_key($config_name, $config_label, $config->get($config_name));
    }
  }

}

/**
 * Create a new key if it doesn't exist.
 */
function create_new_key($key_name, $key_label, $key_value) {
  // Check if the key storage exists.
  if (!\Drupal::entityTypeManager()->hasDefinition('key')) {
    return;
  }
  // Check if the key already exists.
  $key_storage = \Drupal::entityTypeManager()->getStorage('key');
  $key = $key_storage->load($key_name);
  if (!$key) {
    // Create a new key if it doesn't exist.
    $key = $key_storage->create([
      'id' => $key_name,
      'label' => $key_label,
      'key_type' => 'authentication',
      'key_provider' => 'config',
      'provider' => 'ip_info',
      'key_provider_settings' => ['key_value' => $key_value],
      'key_input' => 'text_field',
    ]);
    $key->save();
  }
  // Update the IP Info config.
  $config = \Drupal::service('config.factory')->getEditable('ip_info.settings');
  $config->set($key_name, $key->id());
  $config->save();
}
