<?php

namespace Drupal\ip_info\Config;

use Drupal\Core\Cache\CacheableMetadata;
use Drupal\Core\Config\ConfigFactoryOverrideInterface;
use Drupal\Core\Config\StorageInterface;

/**
 * Overrides the watchdog configuration.
 */
class WatchdogConfigOverrider implements ConfigFactoryOverrideInterface {

  /**
   * {@inheritdoc}
   */
  public function loadOverrides($names) {
    $overrides = [];

    if (in_array('views.view.watchdog', $names)) {
      $overrides['views.view.watchdog']['display']['default']['display_options']['fields']['hostname'] = [
        'id' => 'hostname',
        'table' => 'watchdog',
        'field' => 'hostname',
        'relationship' => 'none',
        'group_type' => 'group',
        'admin_label' => '',
        'label' => 'Hostname',
        'exclude' => 0,
        'alter' => [
          'alter_text' => 0,
          'text' => '',
          'make_link' => 1,
          'path' => 'admin/reports/ip/{{ hostname }}',
          'absolute' => 0,
          'external' => 0,
          'replace_spaces' => 0,
          'path_case' => 'none',
          'trim_whitespace' => 0,
          'word_boundary' => 1,
          'ellipsis' => 1,
          'strip_tags' => 0,
          'html' => 0,
        ],
        'element_class' => '',
        'element_label_colon' => 1,
        'element_wrapper_type' => '',
        'element_default_classes' => 1,
        'hide_alter_empty' => 1,
      ];
    }

    return $overrides;
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheSuffix() {
    return 'WatchdogConfigOverrider';
  }

  /**
   * {@inheritdoc}
   */
  public function getCacheableMetadata($name) {
    return new CacheableMetadata();
  }

  /**
   * {@inheritdoc}
   */
  public function createConfigObject($name, $collection = StorageInterface::DEFAULT_COLLECTION) {
    return NULL;
  }

}
