<?php

declare(strict_types=1);

namespace Drupal\ip_info\Hook;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Link;
use Drupal\Core\Url;

/**
 * Hook implementations used to alter and enhance forms.
 */
class IpInfoFormHooks {

  /**
   * Implements hook_form_alter().
   */
  #[Hook('form_alter')]
  public function formAlter(&$form, FormStateInterface $form_state, $form_id) {
    if ($form_id == 'ban_ip_form') {
      foreach ($form['ban_ip_banning_table']['#rows'] as $key => $row) {
        $ip_address = $row[0];
        $form['ban_ip_banning_table']['#rows'][$key][0] = Link::fromTextAndUrl(
          $ip_address,
          Url::fromRoute('ip_info.ip', ['ip_address' => $ip_address]),
        );
      }
    }
  }

}
