<?php

declare(strict_types=1);

namespace Drupal\ip_info\Hook;

use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;
use Drupal\Core\Url;

/**
 * Hook implementations used to provide help.
 */
class IpInfoHelpHooks {

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'help.page.ip_info':
        $output = '<h2>' . t('About') . '</h2>';
        $output .= '<p>' . t('The IP Info module summarizes information for IPs:') . '</p>';
        $output .= '<ul>';
        $output .= '<li>' . t('Log messages with the IP') . '</li>';
        $output .= '<li>' . t('Is the IP banned?') . '</li>';
        $output .= '<li>' . t('Links to IP lookup services') . '</li>';
        $output .= '</ul>';
        $output .= '<p>' . t('No configuration is required. But you can specify API tokens/keys in the <a href=":config">configuration</a> or in the settings:', [':config' => Url::fromRoute('ip_info.settings')->toString()]) . '</p>';
        $output .= '<pre>$settings[\'ip_info\'][\'ipinfo_io_token\'] = \'your_token\';</pre>';
        $output .= '<pre>$settings[\'ip_info\'][\'ipapi_is_key\'] = \'your_key\';</pre>';
        $output .= '<pre>$settings[\'ip_info\'][\'ipgeolocation_io_key\'] = \'your_key\';</pre>';
        $output .= '<pre>$settings[\'ip_info\'][\'ipstack_com_key\'] = \'your_key\';</pre>';
        $output .= '<pre>$settings[\'ip_info\'][\'ipapi_co_enable\'] = TRUE;</pre>';
        $output .= '<p>' . t('The token/key is used to display information about IPs directly in the Drupal administration.') . '</p>';
        $output .= '<p>' . t('See the <a href=":url">module page</a> for more information.', [':url' => 'https://www.drupal.org/project/ip_info']) . '</p>';
        return $output;
    }
  }

}
