<?php

declare(strict_types=1);

namespace Drupal\ip_info\Services;

use Drupal\crowdsec\CtiInterface;

/**
 * Interface for the CrowdSec IP info services.
 */
interface CrowdSecInterface {

  /**
   * Set the Crowdsec CTI service.
   *
   * @param \Drupal\crowdsec\Cti $cti
   *   The CrowdSec CTI service.
   *
   * @return void
   *   Return nothing.
   */
  public function setCtiService(?CtiInterface $cti = NULL): void;

  /**
   * Provides all data about a given IP address.
   *
   * @param string $ip
   *   The IP address.
   *
   * @return array
   *   The data.
   */
  public function getAllData(string $ip): array;

}
