<?php

declare(strict_types=1);

namespace Drupal\ip_info\Services;

/**
 * Interface for webform submissions list service.
 */
interface WebformSubmissionsListInterface {

  /**
   * Check if the webform module is available.
   *
   * @return bool
   *   TRUE if the webform module classes are available.
   */
  public function isWebformModuleAvailable(): bool;

  /**
   * Check if the current user has permission to view webform submissions.
   *
   * @return bool
   *   TRUE if the user can view submissions.
   */
  public function hasViewPermission(): bool;

  /**
   * Build a render array for webform submissions from a specific IP address.
   *
   * @param string $ip_address
   *   The IP address to filter submissions by.
   * @param int $limit
   *   The maximum number of submissions to display.
   *
   * @return array
   *   A render array containing the webform submissions table.
   */
  public function buildSubmissionsList(string $ip_address, int $limit = 20): array;

  /**
   * Build a render array for webform submission statistics from a specific IP.
   *
   * @param string $ip_address
   *   The IP address to get statistics for.
   *
   * @return array
   *   A render array containing submission statistics.
   */
  public function buildSubmissionStats(string $ip_address): array;

}
