# IP Limiter Module

The IP Limiter module provides functionality to limit the number of requests
from a single IP address to specific paths on your Drupal site. This can help
prevent abuse and reduce server load.

## Features

- Limit the number of requests from a single IP address within a specified time
period.
- Automatically ban IP addresses that exceed the request limit.
- Configurable ban duration and request limits.
- Customizable response type for banned IP addresses (e.g., 403 Forbidden,
404 Not Found).
- Automatic cleanup of old ban entries via cron.

## Installation

Install normally through Composer:

```bash
composer require drupal/ip_limiter
```

Enable the module:

```bash
drush en ip_limiter
```

## Configuration

Configure the module by visiting the IP Limiter settings page at
`/admin/config/system/ip-limiter`.

## How it Works

The IP Limiter module works by tracking requests from IP addresses to specific
paths on your site. When a request is made, the module checks if the IP address
has exceeded the request limit within the specified time period. If so, the IP
address is banned for the configured duration.

## Contributing

Feature requests, bug reports, and merge requests are welcomed. Please follow
the [Drupal coding standards](https://www.drupal.org/docs/develop/standards) and
[best practices](https://www.drupal.org/docs/develop/standards/best-practices-for-drupal-development).
Merge requests should contain test coverage.

All development takes place in
[Drupal.org](https://www.drupal.org/project/ip_limiter).

We're using [DDEV](https://ddev.com) together with [DDEV integration for
developing Drupal contrib projects](https://github.com/ddev/ddev-drupal-contrib)
add-on the for module development:

* To get familiar with DDEV, visit https://ddev.readthedocs.io/en/stable/
* Read the add-on instructions at https://github.com/ddev/ddev-drupal-contrib

## Maintainers

- [Ilias Dimopoulos](https://www.drupal.org/u/idimopoulos-0)
- [Vaggelis Pappas](https://www.drupal.org/u/apso)
