# INTRODUCTION

This module provides recommended configuration for the Fastly, Memcache,
and Monolog repos so that they are configured to take advantage of the
underlying Ironstar platform.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/ironstar).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/ironstar).


# REQUIREMENTS

To enable Monolog configuration and logging you must have the [monolog](https://www.drupal.org/project/monolog) module installed.


# INSTALLATION

The Ironstar module can be installed using Composer.

```shell
composer require drupal/ironstar
```


# CONFIGURATION

## Monolog

>>> [!important]
If you have existing `monolog.handlers` with a conflicting log path as this
module (`/app/logs/drupal.log`), this modules handler will take priority and
disable the conflicting handler to avoid duplicate logs.
>>>

The Monolog configuration is available at `/admin/config/development/ironstar`.

The config in the UI can be overridden with environment variables:
- `IRONSTAR_DRUPAL_ENABLE_MONOLOG` - If this is set (to any value) it enables
this log handler.
- `IRONSTAR_DRUPAL_LOG_LEVEL` - Update the log level of the handler (default
`Notice`), must be one of:
  - `Debug`
  - `Info`
  - `Notice`
  - `Warning`
  - `Error`
  - `Critical`
  - `Alert`
  - `Emergency`

To apply any configuration changes you must run `drush cr`


## Purge Queue Status

The purge queue status is available at the `/admin/reports/purge/queue/status`
route when the [purge](https://www.drupal.org/project/purge) module is installed.

This endpoint offers the same stats as `drush p:queue-stats --format=json` which
can be scraped for custom metrics.
