<?php

namespace Drupal\ironstar\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Listens to the dynamic route events.
 */
class FastlyRouteSubscriber extends RouteSubscriberBase {
  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection): void {
    if ($route = $collection->get('fastly.edge_modules')) {
      $route->setRequirement('_access', 'FALSE');
    }
    if ($route = $collection->get('fastly.settings.image_optimizer')) {
      $route->setRequirement('_access', 'FALSE');
    }
  }

}
