<?php

namespace Drupal\ironstar\EventSubscriber;

use Drupal\Core\Messenger\MessengerInterface;
use Drupal\Core\Routing\CurrentRouteMatch;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;

/**
 * Provides status message when using Fastly module on Ironstar platform.
 */
class FastlyEventSubscriber implements EventSubscriberInterface {
  use StringTranslationTrait;

  /**
   * The messenger service.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected MessengerInterface $messenger;

  /**
   * The current_route_match service.
   *
   * @var \Drupal\Core\Routing\CurrentRouteMatch
   */
  protected CurrentRouteMatch $routeMatch;

  /**
   * Constructs a FastlyEventSubscriber object.
   *
   * @param Drupal\Core\Messenger\MessengerInterface $messenger
   *   The messenger service.
   * @param Drupal\Core\Routing\CurrentRouteMatch $route_match
   *   The current_route_match service.
   */
  public function __construct(
    MessengerInterface $messenger,
    CurrentRouteMatch $route_match,
  ) {
    $this->messenger = $messenger;
    $this->routeMatch = $route_match;
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      KernelEvents::REQUEST => 'onKernelRequest',
    ];
  }

  /**
   * Writes a status message to routes managed in the Ironstar console.
   */
  public function onKernelRequest(): void {
    $route_name = $this->routeMatch->getRouteName();

    $target_routes = [
      'fastly.settings',
      'fastly.edge_modules',
      'fastly.settings.image_optimizer',
    ];

    if (in_array($route_name, $target_routes)) {
      $this->messenger->addMessage($this->t('Since the Ironstar module is enabled, some features are locked. Please manage your Fastly configuration in the Ironstar Console', ['@route' => $route_name]));
    }
  }

}
