Itok Config
Provides a way to output image style URLs without the ?itok= token specifically for metatags (e.g., Open Graph og:image), while preserving full itok protection on the site itself.
Features

Adds a checkbox to each image style: "Provide clean URL token (no itok) for metatags".
When enabled, introduces a new token variant ending in :clean_url (e.g., [node:field_image:large:clean_url]).
The normal :url token continues to include the itok parameter for security.
No global security changes required — allow_insecure_derivatives stays disabled.

Installation

Download and install the module
Using Composer (recommended):textcomposer require drupal/itok_config
drush pm-enable itok_configOr download from Drupal.org and place the module in /modules/contrib/itok_config, then enable it via the Drupal UI or Drush.
Clear caches:textdrush cache:rebuild

Configuration

Go to Admin > Configuration > Media > Image styles
(/admin/config/media/image-styles).
Edit the image style you use for social sharing (e.g., sharing_image_watermark).
In the new fieldset "Itok Config: Clean URL for Metatags", check the box:
Provide clean URL token (no itok) for metatags.
Save the image style.
In your metatag configuration (e.g., Metatag defaults for a content type):
Replace the standard token:text[node:field_image:stylename:url]with the clean version:text[node:field_image:stylename:clean_url]Example:text[node:field_pdf_preview:sharing_image_watermark:clean_url]
Clear caches again if needed:textdrush cr

Usage Example
After configuration:

Normal page rendering: https://example.com/.../image.jpg?itok=abc123 (protected).
Metatag og:image: https://example.com/.../image.jpg (clean, no itok).

Security Note
This module does not disable itok validation globally. The clean URL is only provided via the special :clean_url token for metatags. All regular image display remains fully protected against unauthorized derivative generation.
Requirements

Drupal 9, 10, or 11
Token module

Recommended Modules

Metatag (for the primary og:image use case)

Support
File issues at: https://www.drupal.org/project/issues/itok_config
