# ITOK CONFIG

## CONTENTS OF THIS FILE

 - Introduction
 - Features
 - Installation
 - Configuration
 - Requirements

## INTRODUCTION

Provides a way to output image style URLs without the ?itok= token specifically for metatags (e.g., Open Graph og:image), while preserving full itok protection on the site itself.

## FEATURES

- Adds a checkbox to each image style: "Provide clean URL token (no itok) for metatags".
- When enabled, introduces a new token variant ending in :clean_url (e.g., [node:field_image:large:clean_url]).
- The normal :url token continues to include the itok parameter for security.
- No global security changes required — allow_insecure_derivatives stays disabled.

## INSTALLATION

1. composer require drupal/itok_config
2. drush pm-enable itok_config
3. drush cache:rebuild

## CONFIGURATION

1. Go to Admin > Configuration > Media > Image styles
(/admin/config/media/image-styles).
2. Edit the image style you use for social sharing
3. In the new fieldset "Itok Config: Clean URL for Metatags", check the box:
Provide clean URL token (no itok) for metatags.
4. Save the image style.
5. In your metatag configuration (e.g., Metatag defaults for a content type):
Replace the standard token: [node:field_image:stylename:url] with the clean version: [node:field_image:stylename:clean_url]

## REQUIREMENTS
- Drupal 9, 10, or 11
- Token module
