<?php

namespace Drupal\itok_config;

use Drupal\image\Entity\ImageStyle as CoreImageStyle;

/**
 * Extends the core ImageStyle entity to allow per-style itok disabling.
 */
class ImageStyle extends CoreImageStyle {

  /**
   * {@inheritdoc}
   */
  public function buildUrl($uri) {
    // Get the base URL from the parent class.
    $url = parent::buildUrl($uri);

    // If disable_itok is enabled for this style, strip the itok query param.
    if ($this->getThirdPartySetting('itok_config', 'disable_itok', FALSE)) {
      // Parse the URL and remove the 'itok' query.
      $parsed_url = parse_url($url);
      if (isset($parsed_url['query'])) {
        parse_str($parsed_url['query'], $query);
        unset($query['itok']);
        $parsed_url['query'] = http_build_query($query);
      }
      // Rebuild the URL without itok.
      $scheme = isset($parsed_url['scheme']) ? $parsed_url['scheme'] . '://' : '';
      $host = isset($parsed_url['host']) ? $parsed_url['host'] : '';
      $port = isset($parsed_url['port']) ? ':' . $parsed_url['port'] : '';
      $user = isset($parsed_url['user']) ? $parsed_url['user'] : '';
      $pass = isset($parsed_url['pass']) ? ':' . $parsed_url['pass']  : '';
      $pass = ($user || $pass) ? "$pass@" : '';
      $path = isset($parsed_url['path']) ? $parsed_url['path'] : '';
      $query = isset($parsed_url['query']) ? '?' . $parsed_url['query'] : '';
      $fragment = isset($parsed_url['fragment']) ? '#' . $parsed_url['fragment'] : '';
      $url = "$scheme$user$pass$host$port$path$query$fragment";
    }

    return $url;
  }

}
