<?php
// $Id: itweak_login.pages.inc,v 1.2 2009/05/29 06:59:21 iva2k Exp $

/**
 * @file
 * Implementation of itweak_login forms.
 */

/**
 * Module settings form.
 */
function _itweak_login_admin_settings() {
  $form = array();

  $form['itweak_login_register_button'] = array(
    '#type' => 'checkbox',
    '#title' => t('Show "' . ITWEAK_LOGIN_REGISTER_BTN_NAME . '" button on user login'),
    '#default_value' => variable_get('itweak_login_register_button', FALSE),
    '#description' => t('If checked, use "' . ITWEAK_LOGIN_REGISTER_BTN_NAME . '" button instead of the "Create new account" link on Login page.'),
  );

  $form['itweak_login_register_button_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Name for "' . ITWEAK_LOGIN_REGISTER_BTN_NAME . '" button'),
    '#default_value' => variable_get('itweak_login_register_button_name', ''),
    '#description' => t('(Only if "Show button" is enabled) Text to use as "' . ITWEAK_LOGIN_REGISTER_BTN_NAME . '" button label.  Leave empty to use the default.'),
  );

  $form['itweak_login_login_button_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Name for "' . ITWEAK_LOGIN_LOGIN_BTN_NAME . '" button'),
    '#default_value' => variable_get('itweak_login_login_button_name', ''),
    '#description' => t('Text to use as "' . ITWEAK_LOGIN_LOGIN_BTN_NAME . '" button label.  Leave empty to use the default.'),
  );

  $form['itweak_login_register_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Text for "Create new account" link'),
    '#default_value' => variable_get('itweak_login_register_name', ''),
    '#description' => t('(Only if "Show button" is disabled) Text to use in the "Create new account" link.  Leave empty to use the default.'),
  );

  $form['itweak_login_recover_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Text for "Request new password" link'),
    '#default_value' => variable_get('itweak_login_recover_name', ''),
    '#description' => t('Text to use in the "Request new password" link.  Leave empty to use the default.'),
  );

  $form['itweak_login_recover_url'] = array(
    '#type' => 'textfield',
    '#title' => t('URL for "Request new password" link'),
    '#default_value' => variable_get('itweak_login_recover_url', ''),
    '#description' => t('URL to use in the "Request new password" link.  Leave empty to use the default (user/password).'),
  );
  return $form;
}
function itweak_login_admin_settings() {
  return system_settings_form(_itweak_login_admin_settings());
}

/**
 * After_build callback for login forms.
 */
function itweak_login_form_after_build($form, &$form_state) {
  // FAPI ensures a weight is assigned to all elements before after_build
  // callback is invoked.

  // Get the weight assigned to the submit button.
  $original_submit_weight = $form['submit']['#weight'];
/*
  // Increase the weight of all elements with a weight equal or
  // greater to the weight assigned to the submit button to make
  // room for the "Register" button.
  foreach (element_children($form) as $key) {
    if (isset($form[$key]) && $form[$key]) {
      if ($form[$key]['#weight'] >= $original_submit_weight) {
        $form[$key]['#weight'] += 1;
      }
    }
  }
*/

  // Give the "Register" button the weight originally assigned
  // to the submit button + tiny bit - that will place it right after the "Log in" button.
  $form['register']['#weight'] = $original_submit_weight + 0.001;

  // Ensure drupal_render() performs the sort by weight step on the form.
  unset($form['#sorted']);

  // Adjust the tabindex of the plain login form.
  if (isset($form['submit']['#attributes']) && isset($form['submit']['#attributes']['tabindex'])) {
    $tabindex = (int)$form['submit']['#attributes']['tabindex'];
    $form['register']['#attributes']['tabindex'] = $tabindex + 1;
  }

  return $form;
}
